IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_SAI_EST_WMS_ENT]')) 
	BEGIN 
		RETURN;
	END
ELSE
BEGIN
	CREATE TABLE [dbo].[EST_NF_SAI_EST_WMS_ENT](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL_ORIG] [int] NOT NULL,
		[CD_NF_ORIG] [int] NOT NULL,
		[CD_PED_WMS] [int] NOT NULL,
		[DT_CAD] [datetime] NOT NULL,
	 CONSTRAINT [PK_EST_NF_SAI_EST_WMS_ENT] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL_ORIG] ASC,
		[CD_NF_ORIG] ASC,
		[CD_PED_WMS] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
	 CONSTRAINT [IX_EST_NF_SAI_EST_WMS_ENT] UNIQUE NONCLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL_ORIG] ASC,
		[CD_NF_ORIG] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]


	ALTER TABLE [dbo].[EST_NF_SAI_EST_WMS_ENT] ADD  CONSTRAINT [DF_EST_NF_SAI_EST_WMS_ENT_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[EST_NF_SAI_EST_WMS_ENT] ADD  CONSTRAINT [DF_EST_NF_SAI_EST_WMS_ENT_CD_FILIAL_ORIG]  DEFAULT ((0)) FOR [CD_FILIAL_ORIG]

	ALTER TABLE [dbo].[EST_NF_SAI_EST_WMS_ENT] ADD  CONSTRAINT [DF_EST_NF_SAI_EST_WMS_ENT_CD_NF_ORIG]  DEFAULT ((0)) FOR [CD_NF_ORIG]

	ALTER TABLE [dbo].[EST_NF_SAI_EST_WMS_ENT] ADD  CONSTRAINT [DF_EST_NF_SAI_EST_WMS_ENT_CD_PED_WMS]  DEFAULT ((0)) FOR [CD_PED_WMS]

	ALTER TABLE [dbo].[EST_NF_SAI_EST_WMS_ENT] ADD  CONSTRAINT [DF_EST_NF_SAI_EST_WMS_ENT_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

	ALTER TABLE [dbo].[EST_NF_SAI_EST_WMS_ENT]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_EST_WMS_ENT_EST_NF_SAI] FOREIGN KEY([CD_EMP], [CD_FILIAL_ORIG], [CD_NF_ORIG])
	REFERENCES [dbo].[EST_NF_SAI] ([CD_EMP], [CD_FILIAL], [CD_NF])

	ALTER TABLE [dbo].[EST_NF_SAI_EST_WMS_ENT] CHECK CONSTRAINT [FK_EST_NF_SAI_EST_WMS_ENT_EST_NF_SAI]

	ALTER TABLE [dbo].[EST_NF_SAI_EST_WMS_ENT]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_EST_WMS_ENT_EST_WMS_ENT] FOREIGN KEY([CD_PED_WMS])
	REFERENCES [dbo].[EST_WMS_ENT] ([CD_PED_WMS])

	ALTER TABLE [dbo].[EST_NF_SAI_EST_WMS_ENT] CHECK CONSTRAINT [FK_EST_NF_SAI_EST_WMS_ENT_EST_WMS_ENT]
END
